# Generated by Django 4.0.3 on 2022-04-11 18:50

import cuser.middleware
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(verbose_name='URL')),
                ('status', models.IntegerField(choices=[(0, 'active'), (1, 'inactive')], default=0)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(blank=True, default=cuser.middleware.CuserMiddleware.get_user, on_delete=django.db.models.deletion.CASCADE, related_name='domains', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Link',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=256)),
                ('slug', models.SlugField(help_text='Set a custom slug or leave it emply to generate a random one for you, automatically!', max_length=40, unique=True)),
                ('status', models.IntegerField(choices=[(0, 'active'), (1, 'inactive')], default=0)),
                ('original_url', models.URLField(help_text='A link to redirect to.', verbose_name='Original URL')),
                ('updated', models.DateTimeField(auto_now=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('domain', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='links', to='links_manager.domain')),
                ('user', models.ForeignKey(blank=True, default=cuser.middleware.CuserMiddleware.get_user, on_delete=django.db.models.deletion.CASCADE, related_name='links', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Stat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip', models.GenericIPAddressField(verbose_name='IP')),
                ('country', django_countries.fields.CountryField(max_length=2)),
                ('city', models.CharField(blank=True, max_length=40, null=True)),
                ('region', models.CharField(blank=True, max_length=40, null=True)),
                ('browser', models.CharField(blank=True, max_length=32, null=True)),
                ('os', models.CharField(blank=True, max_length=32, null=True, verbose_name='OS')),
                ('device', models.CharField(blank=True, max_length=32, null=True)),
                ('device_type', models.IntegerField(choices=[(0, 'PC'), (1, 'Mobile'), (2, 'Tablet'), (3, 'Unknown')], default=3)),
                ('referer', models.CharField(blank=True, max_length=256, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('link', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='stats', to='links_manager.link')),
                ('user', models.ForeignKey(blank=True, default=cuser.middleware.CuserMiddleware.get_user, on_delete=django.db.models.deletion.CASCADE, related_name='stats', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
    ]
